@extends('user')
@section('style')

@stop
@section('content')
    @include('partials.breadcrumb')


    <!-- login begin-->
    <div class="contact login">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    @include('errors.alert')

                    <form action="" method="post" class="contact-form">
                        @csrf

                        <div class="row">
                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label>@lang('Current Password')<span class="requred">*</span></label>
                                    <input type="password" name="current_password" placeholder="@lang('Current Password')"   class="form-control" required>
                                    @if ($errors->has('current_password'))
                                        <span class="error">{{ __($errors->first('current_password')) }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="InputName">@lang('New Password')<span class="requred">*</span></label>
                                    <input type="password" name="password"  placeholder="@lang('New Password')" class="form-control" required>
                                    @if ($errors->has('password'))
                                        <span class="error">{{ __($errors->first('password')) }}</span>
                                    @endif
                                </div>
                            </div>


                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label>@lang('Confirm Password')<span class="requred">*</span></label>
                                    <input type="password" name="password_confirmation" class="form-control" placeholder="@lang('Confirm Password')">

                                </div>
                            </div>


                            <div class="col-xl-12 col-lg-12">
                                <button type="submit" id="custom-button">@lang('Submit')</button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- login end -->
@stop


@section('script')
@stop
@section('js')

@stop